package jcircus.environment;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jcircus.exceptions.ChanSyncUnificationException;

import jcircus.util.ChanSync;
import net.sourceforge.czt.z.ast.Name;


/**
 * ChanSyncEnv.java
 *
 * @author Angela Freitas
 */
public class ChanSyncEnv {
    
    /**
     * String (channelName) -> ChanSync
     */
    private Hashtable hashtable_;
    
    /**
     * Constructor.
     */
    public ChanSyncEnv() {
        this.hashtable_ = new Hashtable();
    }
    
    /**
     * 
     * @param channelName
     * @param chanSync
     * @throws ChannelAlreadyDefinedException
     */
    public void put(String channelName, ChanSync chanSync) {
        
        if (chanSync == null)
            throw new NullPointerException();
        
        this.hashtable_.put(channelName, chanSync);
    }
    
    /**
     *
     * @param channelName
     * @return
     */
    public ChanSync get(String channelName) {
        
        return (ChanSync) this.hashtable_.get(channelName);
    }
    
    /**
     *
     * @param channelName
     */
    public void remove(String channelName) {
        
        this.hashtable_.remove(channelName);
    }
    
    /**
     *
     * @param channelName
     * @return
     */
    public boolean containsKey(String channelName) {
        return this.hashtable_.containsKey(channelName);
    }
    
    /**
     *
     * @param channelSyncEnvironment
     * @throws ChannelAlreadyDefinedException
     */
    private void putAll(ChanSyncEnv channelSyncEnvironment) {
        
        Iterator iterator = channelSyncEnvironment.iteratorKeys();
        String channelName;
        ChanSync syncTypeChannel;
        
        while(iterator.hasNext()) {
            channelName = (String) iterator.next();
            syncTypeChannel = channelSyncEnvironment.get(channelName);
            
            this.put(channelName, syncTypeChannel);
        }
    }
    
    /**
     *
     * @param newChannels
     * @param oldChannels
     * @return
     * @throws ChannelAlreadyDefinedException
     */
    public ChanSyncEnv substitute(List newChannels, List oldChannels) {
        
        ChanSyncEnv r = new ChanSyncEnv();
        String channelName, newChannelName;
        Name name;
        ChanSync syncTypeChannel;
        int index;
        
        r.putAll(this);
        
        for (int i = 0; i < oldChannels.size(); i++) {
            
            name = (Name) oldChannels.get(i);
            newChannelName = ((Name) newChannels.get(i)).toString();
            
            if (r.containsKey(name.toString())) {
                syncTypeChannel = r.get(name.toString());
                r.remove(name.toString());
                r.put(newChannelName, syncTypeChannel);
            }
        }
        
        return r;
    }

    /**
     *
     */
    public ChanSyncEnv merge(ChanSyncEnv other) throws ChanSyncUnificationException {
        
        ChanSyncEnv r = new ChanSyncEnv();
        
        r.putAll(this);
        
        Iterator iterator = other.iteratorKeys();
        
        while(iterator.hasNext()) {
            String chanName = (String) iterator.next();
            ChanSync chanSync = other.get(chanName);
            
            if (r.containsKey(chanName)) {
                ChanSync chanSyncInEnv = r.get(chanName);
                if (!chanSync.equals(chanSyncInEnv)) {
                    throw new ChanSyncUnificationException();
                }
            }
            
            r.put(chanName, chanSync);
        }
       
        return r;
    }
    
    /**
     *
     * @return
     */
    public Iterator iteratorKeys() {
        
        return this.hashtable_.keySet().iterator();
    }
       
    /**
     *
     */
    public void print() {
        
        String name;
        ChanSync type;
        Enumeration en = this.hashtable_.keys();
        
        System.out.println("-------------");
        while (en.hasMoreElements()) {
            
            name = (String) en.nextElement();
            type = (ChanSync) this.hashtable_.get(name);
            
            System.out.println("Name: " + name + ", Type: " + type);
        }
        System.out.println("-------------");
    }
    
}
